/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: OS_Includes.h 13303 2019-11-01 14:10:33Z Robert $:

  Description:
    Headerfile for specific operating system includes

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2018-10-19  Ported from cifXTest_Console V1.0.6.0
    2010-07-20  initial version

**************************************************************************************/

#ifndef __OS_INCLUDES__H
#define __OS_INCLUDES__H

#include <windows.h>
#include <stdio.h>
#include "stdint.h"

#define strdup    _strdup

#pragma warning( disable : 4201)

#ifdef __cplusplus
extern "C"
{
#endif

void*    OS_Memalloc     (uint32_t ulSize);
void     OS_Memfree      (void* pvMem);
void     OS_Memset       (void* pvMem, uint8_t bFill, uint32_t ulSize);
void     OS_Memcpy       (void* pvDest, void* pvSrc, uint32_t ulSize);
int      OS_Memcmp       (void* pvBuf1, void* pvBuf2, uint32_t ulSize);
void     OS_Memmove      (void* pvDest, void* pvSrc, uint32_t ulSize);

int      OS_Strcmp       (const char* pszBuf1, const char* pszBuf2);
int      OS_Strnicmp     (const char* pszBuf1, const char* pszBuf2, uint32_t ulLen);
int      OS_Strlen       (const char* szText);
char*    OS_Strncpy      (char* szDest, const char* szSource, uint32_t ulLength);

void*    OS_FileOpen     (char* szFile, uint32_t* pulFileLen);
void     OS_FileClose    (void* pvFile);
uint32_t OS_FileRead     (void* pvFile, uint32_t ulOffset, uint32_t ulSize, void* pvBuffer);

void     OS_Sleep        (uint32_t ulSleepTimeMs);

void*    OS_CreateLock   (void);
void     OS_EnterLock    (void* pvLock);
void     OS_LeaveLock    (void* pvLock);
void     OS_DeleteLock   (void* pvLock);

int      OS_KbHit        (void);
int      OS_GetChar      (void);
int      OS_GetLastError (void);

#ifdef __cplusplus
}
#endif

#endif /* __OS_INCLUDES__H */
